from typing import List, Optional

from axelrod.action import Action

from axelrod.player import Player

Vector = List[float]

C, D = Action.C, Action.D

class NaiveProber(Player):
    """
    Like tit-for-tat, but it occasionally defects with a small probability.

    Names:

    - Naive Prober: [Li2011]_
    """

    name = "Naive Prober"
    classifier = {
        "memory_depth": 1,
        "stochastic": True,
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    def __init__(self, p: float = 0.1) -> None:
        """
        Parameters
        ----------
        p, float
            The probability to defect randomly
        """
        super().__init__()
        self.p = p
        if (self.p == 0) or (self.p == 1):
            self.classifier["stochastic"] = False

    def strategy(self, opponent: Player) -> Action:
        """Actual strategy definition that determines player's action."""
        # First move
        if len(self.history) == 0:
            return C
        # React to the opponent's last move
        if opponent.history[-1] == D:
            return D
        # Otherwise cooperate, defect with probability 1 - self.p
        if self.p == 0:
            return C
        if self.p == 1:
            return D
        choice = self._random.random_choice(1 - self.p)
        return choice